<?php
add_theme_support('post-thumbnails');
add_theme_support('woocommerce');

// add_action('after_setup_theme', 'mytheme_add_woocommerce_support');
add_action('after_setup_theme', 'poker_register_nav_menu');
if (!function_exists('poker_register_nav_menu')) {
    function poker_register_nav_menu()
    {
        register_nav_menus(
            [
                'header' => 'Header',
                'footer' => 'Footer'
            ]
        );
    }
}
add_filter('nav_menu_css_class', 'poker_menu_nav_class', 10, 2);
if (!function_exists('poker_menu_nav_class')) {
    function poker_menu_nav_class($classes, $item)
    {
        if (in_array('current-menu-item', $classes)) {
            $classes[] = 'active ';
        }
        return $classes;
    }
}

add_filter('upload_mimes', 'poker_mime_types');
if (!function_exists('poker_mime_types')) {
    define('ALLOW_UNFILTERED_UPLOADS', true);
    function poker_mime_types($mimes)
    {
        $mimes['svg'] = 'image/svg+xml';
        return $mimes;
    }
}

/*Contact form 7 remove span*/
add_filter('wpcf7_form_elements', 'poker_remove_span_cf7', 10, 1);
if (!function_exists('poker_remove_span_cf7')) {
    function poker_remove_span_cf7($content)
    {
        // $content = preg_replace('/<(span).*?class="\s*(?:.*\s)?wpcf7-form-control-wrap(?:\s[^"]+)?\s*"[^\>]*>(.*)<\/\1>/i', '\2', $content);
        $content = str_replace('<br />', '', $content);
        return $content;
    }
}

//change reset password url
add_filter('lostpassword_url',  'poker_lostpassword_url', 10, 1);
if (!function_exists('poker_lostpassword_url')) {
    function poker_lostpassword_url($url)
    {
        $url = poker_get_template_page_link('template-page-password-restore.php') ?: $url;
        return $url;
    }
}

//change login url
add_filter('login_url',  'poker_login_url', 10, 1);
if (!function_exists('poker_login_url')) {
    function poker_login_url($url)
    {
        $url = poker_get_template_page_link('template-page-sign-in.php') ?: $url;
        return $url;
    }
}

//change author permalink
add_action('init', 'poker_change_author_permalinks');
if (!function_exists('poker_change_author_permalinks')) {
    function poker_change_author_permalinks()
    {
        global $wp_rewrite;
        $wp_rewrite->author_base = 'personal-page';
        $wp_rewrite->flush_rules();
    }
}

add_action('wp_enqueue_scripts', 'poker_admin_styles');
add_action('admin_enqueue_scripts', 'poker_admin_styles');
if (!function_exists('poker_admin_styles')) {
    function poker_admin_styles()
    {
        $user = wp_get_current_user();
        if (in_array('venue_editor', (array) $user->roles)) {
                wp_enqueue_style('admin-venue-hidden', get_template_directory_uri().'/assets/css/admin_venue_hidden.css');
                wp_enqueue_script('admin-venue-hidden', get_template_directory_uri().'/assets/js/admin_venue_hidden.js');
        }
    }
}
